/*
 * Decompiled with CFR 0.152.
 */
package net.johnvictorfs.simple_utilities.hud;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.johnvictorfs.simple_utilities.config.SimpleUtilitiesConfig;
import net.johnvictorfs.simple_utilities.mixin.GameClientMixin;
import net.minecraft.class_1074;
import net.minecraft.class_1269;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_408;
import net.minecraft.class_5321;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class GameInfoHud {
    private final class_310 client;
    private final class_327 fontRenderer;
    private class_746 player;
    private class_332 context;
    private SimpleUtilitiesConfig config;

    public GameInfoHud(class_310 client) {
        this.client = client;
        this.fontRenderer = client.field_1772;
        this.config = (SimpleUtilitiesConfig)AutoConfig.getConfigHolder(SimpleUtilitiesConfig.class).getConfig();
        AutoConfig.getConfigHolder(SimpleUtilitiesConfig.class).registerSaveListener((manager, data) -> {
            this.config = data;
            return class_1269.field_5812;
        });
    }

    public void draw(class_332 context) {
        if (!this.config.statusElements.toggleSimpleUtilitiesHUD) {
            return;
        }
        this.player = this.client.field_1724;
        this.context = context;
        RenderSystem.enableBlend();
        this.drawInfos();
        this.client.method_16011().method_15407();
    }

    private void drawInfos() {
        List<String> gameInfo = this.getGameInfo();
        if (this.config.statusElements.toggleEquipmentStatus && !(this.client.field_1755 instanceof class_408)) {
            this.drawEquipmentInfo();
        }
        Objects.requireNonNull(this.fontRenderer);
        int lineHeight = 9 + 2;
        int top = 0;
        int left = 4;
        for (String line : gameInfo) {
            this.context.method_25303(this.fontRenderer, line, left, top + 4, this.config.statusElements.textColor);
            top += lineHeight;
        }
        if (this.config.statusElements.toggleSprintStatus && (this.client.field_1690.field_1867.method_1434() || this.player.method_5624())) {
            this.drawSprintingInfo();
        }
    }

    private void drawSprintingInfo() {
        String sprintingText = class_2561.method_43471((String)"text.hud.simple_utilities.sprinting").getString();
        int maxLineHeight = Math.max(10, this.fontRenderer.method_1727(sprintingText));
        maxLineHeight = (int)(Math.ceil((double)maxLineHeight / 5.0 + 0.5) * 5.0);
        int scaleHeight = this.client.method_22683().method_4502();
        int sprintingTop = scaleHeight - maxLineHeight;
        this.context.method_25303(this.fontRenderer, sprintingText, 2, sprintingTop + 20, this.config.statusElements.textColor);
    }

    private static String capitalize(String str) {
        if (str == null) {
            return null;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private String getOffset(class_2350 facing) {
        Object offset = "";
        if (facing.method_10148() > 0) {
            offset = (String)offset + "+X";
        } else if (facing.method_10148() < 0) {
            offset = (String)offset + "-X";
        }
        if (facing.method_10165() > 0) {
            offset = (String)offset + " +Z";
        } else if (facing.method_10165() < 0) {
            offset = (String)offset + " -Z";
        }
        return ((String)offset).trim();
    }

    private String zeroPadding(int number) {
        return number >= 10 ? Integer.toString(number) : String.format("0%s", number);
    }

    private String secondsToString(int pTime) {
        int min = pTime / 60;
        int sec = pTime - min * 60;
        String strMin = this.zeroPadding(min);
        String strSec = this.zeroPadding(sec);
        return String.format("%s:%s", strMin, strSec);
    }

    private void drawStatusEffectInfo() {
        if (this.client.field_1724 != null) {
            Map effects = this.client.field_1724.method_6088();
            for (Map.Entry effect : effects.entrySet()) {
                String effectName = class_1074.method_4662((String)((class_1291)effect.getKey()).method_5567(), (Object[])new Object[0]);
                String duration = this.secondsToString(((class_1293)effect.getValue()).method_5584() / 20);
                int color = ((class_1291)effect.getKey()).method_5556();
                this.context.method_25303(this.fontRenderer, effectName + " " + duration, 40, 200, color);
            }
        }
    }

    private void drawEquipmentInfo() {
        ArrayList<class_1799> equippedItems = new ArrayList<class_1799>();
        class_1661 inventory = this.player.method_31548();
        int maxLineHeight = Math.max(10, this.fontRenderer.method_1727(""));
        class_1799 mainHandItem = inventory.method_7391();
        maxLineHeight = Math.max(maxLineHeight, this.fontRenderer.method_1727(class_1074.method_4662((String)mainHandItem.method_7922(), (Object[])new Object[0])));
        equippedItems.add(mainHandItem);
        for (class_1799 secondHandItem : inventory.field_7544) {
            maxLineHeight = Math.max(maxLineHeight, this.fontRenderer.method_1727(class_1074.method_4662((String)secondHandItem.method_7922(), (Object[])new Object[0])));
            equippedItems.add(secondHandItem);
        }
        for (class_1799 armourItem : this.player.method_31548().field_7548) {
            maxLineHeight = Math.max(maxLineHeight, this.fontRenderer.method_1727(class_1074.method_4662((String)armourItem.method_7922(), (Object[])new Object[0])));
            equippedItems.add(armourItem);
        }
        maxLineHeight = (int)(Math.ceil((double)maxLineHeight / 5.0 + 0.5) * 5.0);
        int itemTop = this.client.method_22683().method_4502() - maxLineHeight;
        Objects.requireNonNull(this.fontRenderer);
        int lineHeight = 9 + 6;
        for (class_1799 equippedItem : Lists.reverse(equippedItems)) {
            if (equippedItem.method_7909().equals(class_2246.field_10124.method_8389())) continue;
            this.context.method_51427(equippedItem, 2, itemTop - 68);
            if (equippedItem.method_7936() != 0) {
                int currentDurability = equippedItem.method_7936() - equippedItem.method_7919();
                String itemDurability = currentDurability + "/" + equippedItem.method_7936();
                int color = this.config.statusElements.textColor;
                if (currentDurability < equippedItem.method_7936()) {
                    color = 3858021;
                }
                if ((double)currentDurability <= (double)equippedItem.method_7936() / 1.5) {
                    color = 14740819;
                }
                if ((double)currentDurability <= (double)equippedItem.method_7936() / 2.5) {
                    color = 15578963;
                }
                if (currentDurability <= equippedItem.method_7936() / 4) {
                    color = 14372687;
                }
                this.context.method_25303(this.fontRenderer, itemDurability, 22, itemTop - 64, color);
            } else {
                int inventoryCount = inventory.method_18861(equippedItem.method_7909());
                int count = equippedItem.method_7947();
                if (inventoryCount > 1) {
                    String itemCount = count + " (" + inventoryCount + ")";
                    this.context.method_25303(this.fontRenderer, itemCount, 22, itemTop - 64, this.config.statusElements.textColor);
                }
            }
            itemTop += lineHeight;
        }
    }

    private static String parseTime(long time) {
        long hours = (time / 1000L + 6L) % 24L;
        long minutes = time % 1000L * 60L / 1000L;
        String ampm = "AM";
        if (hours >= 12L) {
            hours -= 12L;
            ampm = "PM";
        }
        if (hours == 0L) {
            hours = 12L;
        }
        Object mm = "0" + minutes;
        mm = ((String)mm).substring(((String)mm).length() - 2);
        return hours + ":" + (String)mm + " " + ampm;
    }

    private List<String> getGameInfo() {
        ArrayList<String> gameInfo = new ArrayList<String>();
        if (this.config.statusElements.toggleCoordinatesStatus || this.config.statusElements.toggleDirectionStatus) {
            Object coordDirectionStatus = "";
            class_2350 facing = this.player.method_5735();
            String translatedDirection = class_2561.method_43471((String)("text.direction.simple_utilities." + facing.method_15434())).getString();
            String direction = translatedDirection + " " + this.getOffset(facing);
            if (this.config.statusElements.toggleCoordinatesStatus) {
                String coordsFormat = "%d, %d, %d";
                coordDirectionStatus = (String)coordDirectionStatus + String.format(coordsFormat, (int)this.player.method_23317(), (int)this.player.method_23318(), (int)this.player.method_23321());
                if (this.config.statusElements.toggleDirectionStatus) {
                    coordDirectionStatus = (String)coordDirectionStatus + " (" + direction + ")";
                }
            } else if (this.config.statusElements.toggleDirectionStatus) {
                coordDirectionStatus = (String)coordDirectionStatus + direction;
            }
            gameInfo.add((String)coordDirectionStatus);
        }
        if (this.config.statusElements.toggleNetherCoordinateConversion) {
            String coordsFormat = "X: %.0f, Z: %.0f";
            if (this.player.method_37908().method_27983().method_29177().toString().equals("minecraft:overworld")) {
                gameInfo.add("Nether: " + String.format(coordsFormat, this.player.method_23317() / 8.0, this.player.method_23321() / 8.0));
            } else if (this.player.method_37908().method_27983().method_29177().toString().equals("minecraft:the_nether")) {
                gameInfo.add("Overworld: " + String.format(coordsFormat, this.player.method_23317() * 8.0, this.player.method_23321() * 8.0));
            }
        }
        if (this.config.statusElements.toggleFpsStatus) {
            gameInfo.add(String.format("%d fps", ((GameClientMixin)class_310.method_1551()).getCurrentFps()));
        }
        if (this.config.statusElements.togglePlayerSpeedStatus) {
            class_243 playerPosVec = Objects.requireNonNull(this.client.field_1724).method_19538();
            double travelledX = playerPosVec.field_1352 - this.client.field_1724.field_6014;
            double travelledZ = playerPosVec.field_1350 - this.client.field_1724.field_5969;
            double currentSpeed = class_3532.method_15355((float)((float)(travelledX * travelledX + travelledZ * travelledZ)));
            gameInfo.add(String.format("%.2f m/s", currentSpeed / (double)0.05f));
        }
        if (this.client.field_1687 != null) {
            Optional biome;
            if (this.config.statusElements.toggleLightLevelStatus) {
                int lightLevel = this.client.field_1687.method_22339(Objects.requireNonNull(this.client.field_1724).method_24515());
                gameInfo.add("Light Level: " + lightLevel);
            }
            if (this.config.statusElements.toggleBiomeStatus && (biome = this.client.field_1687.method_23753(this.player.method_24515()).method_40230()).isPresent()) {
                String biomeName = class_2561.method_43471((String)("biome." + ((class_5321)biome.get()).method_29177().method_12836() + "." + ((class_5321)biome.get()).method_29177().method_12832())).getString();
                gameInfo.add(class_2561.method_43469((String)"text.hud.simple_utilities.biome", (Object[])new Object[]{GameInfoHud.capitalize(biomeName)}).getString());
            }
            if (this.config.statusElements.toggleGameTimeStatus) {
                gameInfo.add(GameInfoHud.parseTime(this.client.field_1687.method_8532()));
            }
        }
        if (this.config.statusElements.togglePlayerName) {
            gameInfo.add(this.player.method_5820());
        }
        if (this.config.statusElements.toggleServerName) {
            String serverName = "Singleplayer";
            try {
                serverName = this.client.method_1558().field_3752;
            }
            catch (Exception exception) {
                // empty catch block
            }
            gameInfo.add(serverName);
        }
        if (this.config.statusElements.toggleServerAddress) {
            String serverIp = "N/A";
            try {
                serverIp = this.client.method_1558().field_3761;
            }
            catch (Exception exception) {
                // empty catch block
            }
            gameInfo.add(serverIp);
        }
        return gameInfo;
    }
}

